import Utilities.gui_creator as gc
import Utilities.plot_creator as pc
import numpy as np
import tkinter.filedialog as fd
import scipy.optimize as opt

fname = fd.askopenfilename()
f, g = np.loadtxt(fname, delimiter=',', usecols=(0,1),
                  unpack=True)

root = gc.create_window(title='Resonant Circuit Data Plot',
                        size='1000x500')
control_box, right_frame = gc.create_frames(root)
ax, canvas = pc.create_plot(right_frame)

pc.update_plot(ax, canvas, f, g,
               label_x='Frequency (Hz)',
               label_y='Gain',
               marker='o')


def resonance(f, a, b):
    return 1/np.sqrt(1+((f - a**2/f)/b)**2)

p0 = 2000, 100

popt, pcov = opt.curve_fit(resonance, f, g, p0)

a, b = popt


gc.create_indicator(control_box, label_1='Resoant Frequency (hz)',
                    label_2=f'{a:.0f}')
gc.create_indicator(control_box, label_1='Full Width at Half Power Maximum (hz)', 
                    label_2=f'{b:.0f}')


f_fit = np.linspace(1500, 3000, 1000)
g_fit = resonance(f_fit, a, b)                    

pc.update_plot(ax, canvas, f_fit, g_fit,
               label_x='Frequency (Hz)',
               label_y='Gain',
               clear_flag=False)
